using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using com.paypal.soap.api;
using KashFlowPayPal.Classes;
namespace KashFlowPayPal
{
    public partial class frmSearchDetailView : Form
    {
        public static string _strTransactionID;
        public frmSearchDetailView()
        {
            InitializeComponent();
        }

        private void frmSearchDetailView_Load(object sender, EventArgs e)
        {
            lblDetail.Text = "Obtaining transaction information from PayPal";
            Application.DoEvents();
            timer1.Enabled = true;
            timer1.Interval= 1*1000;
            timer1.Start();


            
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            try
            {
                PayPalAPI objApi = new PayPalAPI();
                GetTransactionDetailsResponseType resType = objApi.GetTransactionDetails(_strTransactionID);
                if (resType.Errors != null && resType.Errors.Length > 0)
                {
                    timer1.Enabled = false;
                    MessageBox.Show(resType.Errors[0].LongMessage);
                    return;
                }
                lblPayerAddress.Text = resType.PaymentTransactionDetails.PayerInfo.Address.Street1 + " , " + resType.PaymentTransactionDetails.PayerInfo.Address.Street2;
                lblAddress2.Text = resType.PaymentTransactionDetails.PayerInfo.Address.CityName + " , " + resType.PaymentTransactionDetails.PayerInfo.Address.PostalCode + " , " + resType.PaymentTransactionDetails.PayerInfo.Address.CountryName;
                lblDetail.Text = resType.PaymentTransactionDetails.PaymentInfo.PaymentStatus.ToString();
                
                lblExchangeRate.Text = resType.PaymentTransactionDetails.PaymentInfo.ExchangeRate;
                if (resType.PaymentTransactionDetails.PaymentInfo.FeeAmount != null)
                    lblFeeAmount.Text = resType.PaymentTransactionDetails.PaymentInfo.FeeAmount.currencyID + " " + resType.PaymentTransactionDetails.PaymentInfo.FeeAmount.Value;
                if (resType.PaymentTransactionDetails.PaymentInfo.GrossAmount != null)
                    lblGrossAmount.Text = resType.PaymentTransactionDetails.PaymentInfo.GrossAmount.currencyID + " " + resType.PaymentTransactionDetails.PaymentInfo.GrossAmount.Value;

                lblPayerName.Text = resType.PaymentTransactionDetails.PayerInfo.PayerName.LastName + "," + resType.PaymentTransactionDetails.PayerInfo.PayerName.FirstName;
                if (resType.PaymentTransactionDetails.PaymentInfo.ParentTransactionID != null)
                    lblParentTransactionID.Text = resType.PaymentTransactionDetails.PaymentInfo.ParentTransactionID;

                lblPayerBusiness.Text = resType.PaymentTransactionDetails.PayerInfo.PayerBusiness;
                lblPayerCountry.Text = resType.PaymentTransactionDetails.PayerInfo.PayerCountry.ToString();
                lblPayerID.Text = resType.PaymentTransactionDetails.PayerInfo.PayerID;
                lblPayer.Text = resType.PaymentTransactionDetails.PayerInfo.Payer;
                lblContactPhone.Text = resType.PaymentTransactionDetails.PayerInfo.ContactPhone;

                if (resType.PaymentTransactionDetails.PaymentInfo != null)
                    lblPaymentType.Text = resType.PaymentTransactionDetails.PaymentInfo.PaymentType.ToString();
                try
                {
                    lblReceiptID.Text = resType.PaymentTransactionDetails.PaymentInfo.ReceiptID;
                }
                catch { }
                try
                {
                    lblSettleAmount.Text = resType.PaymentTransactionDetails.PaymentInfo.SettleAmount.currencyID + "-" + resType.PaymentTransactionDetails.PaymentInfo.SettleAmount.currencyID;
                }
                catch { }
                try
                {
                    lblTaxAmount.Text = resType.PaymentTransactionDetails.PaymentInfo.TaxAmount.currencyID + "-" + resType.PaymentTransactionDetails.PaymentInfo.TaxAmount.currencyID;
                }
                catch { }
                if (resType.PaymentTransactionDetails.PaymentInfo.TransactionType != null)
                    lblTransactionTypw.Text = resType.PaymentTransactionDetails.PaymentInfo.TransactionType.ToString();
                
            }
            catch (Exception ex) { Console.WriteLine(ex.Message); }

            timer1.Enabled = false;
        }

        
    }
}