using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using KashFlowPayPal.Classes;
using com.paypal.soap.api;

namespace KashFlowPayPal
{
    public partial class frmPayPalC : Form
    {
      
        public frmPayPalC()
        {
            InitializeComponent();
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void bntSave_Click(object sender, EventArgs e)
        {
            if (chkRemember.Checked)
            {
                //Save credentials to xml file
                ProgramOptions obj = new ProgramOptions();
                obj.PayPalUserName = txtUserName.Text.Trim();
                obj.PayPalPassword = txtPass.Text.Trim();
                obj.PayPalSignature = txtSignature.Text.Trim();
                PayPalConstants.EncryptPString(txtPass.Text, "payp.bin");
                obj.RememberPayPal = true;
                obj.SavePayPalSettings();
            }

            PayPalConstants._strPayPalPassword = txtPass.Text.Trim();
            PayPalConstants._strPayPalUserName = txtUserName.Text.Trim();
            PayPalConstants._strPayPalSignature = txtSignature.Text.Trim();

            //Update profile to reflect change to PayPal credentials
            SetProfile.DefaultProfile.APIPassword = txtPass.Text.Trim();
            SetProfile.DefaultProfile.APIUsername = txtUserName.Text.Trim();
            SetProfile.DefaultProfile.APISignature = txtSignature.Text.Trim();
            this.Close();
        }

        private void frmMain_Load(object sender, EventArgs e)
        {
            ProgramOptions obj = new ProgramOptions();
            obj.LoadXMLSettings();
            txtUserName.Text= obj.PayPalUserName;
            txtPass.Text = obj.PayPalPassword;
            txtSignature.Text = obj.PayPalSignature;
            try {
                txtPass.Text = PayPalConstants.DecryptPString("payp.bin");
            }
            catch { }
            chkRemember.Checked = obj.RememberPayPal;


        }

        private void btnTest_Click(object sender, EventArgs e)
        {
            if (txtPass.Text != "" && txtUserName.Text != "" && txtSignature.Text != "")
                {

                SetProfile.DefaultProfile.APIPassword = txtPass.Text.Trim();
                SetProfile.DefaultProfile.APIUsername = txtUserName.Text.Trim();
                SetProfile.DefaultProfile.APISignature = txtSignature.Text.Trim();

                PayPalAPI api = new PayPalAPI();

                //Attempt to find a non-existant transaction to check PayPal credentials
                GetTransactionDetailsResponseType resType = api.GetTransactionDetails("0");
                if (resType.Errors != null && resType.Errors.Length > 0)
                {
                    if (resType.Errors[0].ErrorCode == "10002") //Security header invalid
                    {
                        MessageBox.Show("Your PayPal credentials are invalid, please check and try again", "KashFlow", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    }
                    else //Transaction found so credentials are fine
                    {
                        MessageBox.Show("Your PayPal credentials are valid", "PP:Konnect", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                }
            }
            else
                MessageBox.Show("Please enter your PayPal credentials first", "PP:Konnect", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
        }
        
        
    }
}