using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using KashFlowPayPal.Classes;
using KashFlowPayPal.uk.co.kashflow.secure;

namespace KashFlowPayPal
{
    public partial class frmKashFlowC : Form
    {
        
        public frmKashFlowC()
        {
            InitializeComponent();
        }

        
        private void lblExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void bntSave_Click(object sender, EventArgs e)
        {
            if (chkRemember.Checked)
            {
                ProgramOptions obj = new ProgramOptions();
                obj.KashFlowUserName = txtUserID.Text;
                obj.KashFlowUserPassword = txtPass.Text;
                //obj.PayPalSignature = txtSignature.Text;
                PayPalConstants.EncryptPString(txtPass.Text, "kashp.bin");

                obj.RememberKash = true;

                obj.SaveKashflowSettings();
                
            }
            else 
            {
                PayPalConstants._strKashFlowPassword = txtPass.Text;
                PayPalConstants._strKashFlowUserName= txtUserID.Text;
            }
            this.Close();
        }

        private void frmWelcome_Load(object sender, EventArgs e)
        {
            try
            {
                ProgramOptions obj = new ProgramOptions();
                obj.LoadXMLSettings();
                txtUserID.Text = obj.KashFlowUserName;
                txtPass.Text = PayPalConstants.DecryptPString("kashp.bin");
                chkRemember.Checked = obj.RememberKash;
            }
            catch { }

        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void txtTest_Click(object sender, EventArgs e)
        {
            if (txtUserID.Text != "" && txtPass.Text != "")
            {

                KashFlowAPI kash = new KashFlowAPI();
                string strStatus;
                string strStatusDetail;
                bool testCred = kash.isUserVATRegistered(txtUserID.Text, txtPass.Text, out strStatus, out strStatusDetail);
                if (strStatus != "OK")
                    if (strStatusDetail.EndsWith("access list"))
                    {
                        MessageBox.Show("Your KashFlow credentials are valid however you must enable access to the API for your IP address", "PP:Konnect", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        lnkAccesslist.Visible = true;
                        return;
                    }
                    else
                    {
                        MessageBox.Show("Your KashFlow credentials are invalid, please check and try again", "PP:Konnect", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    }
                else
                {
                    MessageBox.Show("Your KashFlow credentials are valid", "PP:Konnect", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                lnkAccesslist.Visible = false;
            }
            else
                MessageBox.Show("Please enter your Kashflow credentials first", "PP:Konnect", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);

        }

        private void lnkAccesslist_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://api.kashflow.co.uk/enableAPI.asp?highlight=4");
        }

       
    }
}