using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System;

namespace KashFlowPayPal.Classes
{
    public class ProgramOptions
    {
        // private members
        string _strKashFlowUserName;
        string _strKashFlowUserPassword;
        bool _boolRememberKash;
        string _strPayPalUserName;
        string _strPayPalPassword;
        string _strPayPalSignature;
        bool _boolRememberPayPal;
        bool _boolAllCustomers;
        string _strCustomerName;
        int _intProductID = 0;
        string _strBankAccountID;
        //string _strPaypalBankAccountID;
        int _intBankTransactionTypeID = 0;
        decimal _decVATRate;
        // empty constructor
        public ProgramOptions()
        {
        }


        // full constructor
        public ProgramOptions(string KashFlowUserName, string KashFlowUserPassword, bool RememberKash, string PayPalUserName, string PayPalPassword, bool RememberPayPal, bool AllCustomers)
        {
            this._strKashFlowUserName = KashFlowUserName;
            this._strKashFlowUserPassword = KashFlowUserPassword;
            this._boolRememberKash = RememberKash;
            this._strPayPalUserName = PayPalUserName;
            this._strPayPalPassword = PayPalPassword;
            this._boolRememberPayPal = RememberPayPal;
            this._boolAllCustomers = AllCustomers;
        }

        // public accessors
        public string KashFlowUserName
        {
            get { return _strKashFlowUserName; }
            set { _strKashFlowUserName = value; }
        }
        public string CustomerName
        {
            get { return _strCustomerName; }
            set { _strCustomerName = value; }
        }
        public int ProductID
        {
            get { return _intProductID; }
            set { _intProductID = value; }
        }
        public string KashFlowUserPassword
        {
            get { return _strKashFlowUserPassword; }
            set { _strKashFlowUserPassword = value; }
        }
        public bool RememberKash
        {
            get { return _boolRememberKash; }
            set { _boolRememberKash = value; }
        }
        public string PayPalUserName
        {
            get { return _strPayPalUserName; }
            set { _strPayPalUserName = value; }
        }
        public string PayPalPassword
        {
            get { return _strPayPalPassword; }
            set { _strPayPalPassword = value; }
        }
        public string PayPalSignature
        {
            get { return _strPayPalSignature; }
            set { _strPayPalSignature = value; }
        }
        public string BankAccountID
        {
            get { return _strBankAccountID; }
            set { _strBankAccountID = value; }
        }

        /*public string PaypalBankAccountID
        {
            get { return _strPaypalBankAccountID; }
            set { _strPaypalBankAccountID = value; }
        }*/

        public int BankTransactionTypeID
        {
            get { return _intBankTransactionTypeID; }
            set { _intBankTransactionTypeID = value; }
        }

        public decimal VATRate
        {
            get { return _decVATRate; }
            set { _decVATRate = value; }
        }

        public bool RememberPayPal
        {
            get { return _boolRememberPayPal; }
            set { _boolRememberPayPal = value; }
        }
        public bool AllCustomers
        {
            get { return _boolAllCustomers; }
            set { _boolAllCustomers = value; }
        }
        public void LoadXMLSettings()
        {
            try
            {
                #region Spider Settings
                XmlDocument docXML = new XmlDocument();
                docXML.Load(System.Windows.Forms.Application.StartupPath + "\\Settings.xml");
                XmlNode f_n;
                XmlNode setting;

                f_n = docXML.FirstChild;


                setting = f_n.ChildNodes[0];

                XmlNode kashFlowUser = setting.ChildNodes[0];
               // XmlNode kashFlowPassword = setting.ChildNodes[1];
                XmlNode rememberKash = setting.ChildNodes[2];
                XmlNode payPalUser= setting.ChildNodes[3];
                XmlNode payPalPassword = setting.ChildNodes[4];
                XmlNode signature = setting.ChildNodes[5];
                XmlNode rememberPayPal = setting.ChildNodes[6];
                XmlNode all_users= setting.ChildNodes[7];

                _strKashFlowUserName = kashFlowUser.InnerText;
                _strKashFlowUserPassword = PayPalConstants.DecryptPString("kashp.bin");
                if (rememberKash.InnerText == "true")
                    _boolRememberKash = true;
                else
                    _boolRememberKash = false;

                _strPayPalUserName = payPalUser.InnerText;
                _strPayPalPassword = PayPalConstants.DecryptPString("payp.bin"); 
                _strPayPalSignature = signature.InnerText;

                if (rememberPayPal.InnerText == "true")
                    _boolRememberPayPal = true;
                else
                    _boolRememberPayPal = false;
                if (all_users.InnerText == "true")
                    _boolAllCustomers = true;
                else
                    _boolAllCustomers = false;


                #endregion Spider Settings
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public void LoadCustomerSettings()
        {
            try
            {
                #region Spider Settings
                XmlDocument docXML = new XmlDocument();
                docXML.Load(System.Windows.Forms.Application.StartupPath + "\\CustomerSettings.xml");
                XmlNode f_n;
                XmlNode setting;

                f_n = docXML.FirstChild;


                setting = f_n.ChildNodes[0];

                XmlNode customer_name = setting.ChildNodes[0];
                XmlNode product_id = setting.ChildNodes[1];
                XmlNode all_users = setting.ChildNodes[2];
                XmlNode bankAccount = setting.ChildNodes[3];
                //XmlNode paypalBankAccount = setting.ChildNodes[4];
                XmlNode bankTxType = setting.ChildNodes[4];
                XmlNode vatRate = setting.ChildNodes[5];

                _strCustomerName = customer_name.InnerText;
                try
                {
                    _intProductID = int.Parse(product_id.InnerText);
                }
                catch { }

                try
                {
                    _intBankTransactionTypeID = int.Parse(bankTxType.InnerText);
                }
                catch { }

                try
                {
                    _decVATRate = decimal.Parse(vatRate.InnerText);
                }
                catch { }


                if (all_users.InnerText == "true")
                    _boolAllCustomers = true;
                else
                    _boolAllCustomers = false;
                _strBankAccountID = bankAccount.InnerText;
                //_strPaypalBankAccountID = paypalBankAccount.InnerText;

                
                #endregion Spider Settings
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
        public void SaveCustomerSettings()
        {
            try
            {
                #region Spider Settings
                XmlDocument docXML = new XmlDocument();
                docXML.Load(System.Windows.Forms.Application.StartupPath + "\\CustomerSettings.xml");
                XmlNode f_n;
                XmlNode setting;

                f_n = docXML.FirstChild;

                
                setting = f_n.ChildNodes[0];

                XmlNode customer_name = setting.ChildNodes[0];
                XmlNode product_id = setting.ChildNodes[1];
                XmlNode all_users = setting.ChildNodes[2];
                XmlNode bankAccount = setting.ChildNodes[3];
                //XmlNode paypalBankAccount = setting.ChildNodes[4];
                XmlNode bankTxType = setting.ChildNodes[4];
                XmlNode vatRate = setting.ChildNodes[5];
                
                customer_name.InnerText = _strCustomerName;
                product_id.InnerText = Convert.ToString(_intProductID);
                if (_boolAllCustomers)
                    all_users.InnerText = "true";
                else
                    all_users.InnerText = "false";
                bankAccount.InnerText = _strBankAccountID;
                //paypalBankAccount.InnerText = _strPaypalBankAccountID;
                bankTxType.InnerText = Convert.ToString(_intBankTransactionTypeID);
                vatRate.InnerText = Convert.ToString(_decVATRate);

                docXML.Save(System.Windows.Forms.Application.StartupPath + "\\CustomerSettings.xml");

                #endregion Spider Settings
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public void SavePayPalSettings()
        {
            try
            {
                #region Spider Settings
                XmlDocument docXML = new XmlDocument();
                docXML.Load(System.Windows.Forms.Application.StartupPath + "\\Settings.xml");
                XmlNode f_n;
                XmlNode setting;

                f_n = docXML.FirstChild;
                setting = f_n.ChildNodes[0];

                XmlNode payPalUser = setting.ChildNodes[3];
               // XmlNode payPalPassword = setting.ChildNodes[4];
                XmlNode signature = setting.ChildNodes[5];
                XmlNode rememberPayPal = setting.ChildNodes[6];


                payPalUser.InnerText = _strPayPalUserName;
               // payPalPassword.InnerText = _strPayPalPassword;
                signature.InnerText = _strPayPalSignature;

                rememberPayPal.InnerText = "true";
                docXML.Save(System.Windows.Forms.Application.StartupPath + "\\Settings.xml");
                
                #endregion Spider Settings
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }


        public void SaveKashflowSettings()
        {
            try
            {
                #region Spider Settings
                XmlDocument docXML = new XmlDocument();
                docXML.Load(System.Windows.Forms.Application.StartupPath + "\\Settings.xml");
                XmlNode f_n;
                XmlNode setting;

                f_n = docXML.FirstChild;
                setting = f_n.ChildNodes[0];

                XmlNode KashFlowUserName = setting.ChildNodes[0];
                XmlNode KashFlowUserPassword = setting.ChildNodes[1];
                XmlNode RememberKash = setting.ChildNodes[2];


                KashFlowUserName.InnerText = _strKashFlowUserName;
               KashFlowUserPassword.InnerText = _strKashFlowUserPassword;
                  
                RememberKash.InnerText = "true";
                docXML.Save(System.Windows.Forms.Application.StartupPath + "\\Settings.xml");

                #endregion Spider Settings
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
    }
}
