using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Security.Cryptography;
namespace KashFlowPayPal.Classes
{

    class PayPalConstants
    {
        public static string API_USERNAME;
        public static string API_PASSWORD = "";
        public static string KASH_API_USERNAME = "";
        public static string KASH_API_PASSWORD = "";
        public static string API_SIGNATURE = "";
        public const string CERTIFICATE = "sdk-seller.p12";
        public const string PRIVATE_KEY_PASSWORD = "password";
        public const string SUBJECT = "";
        //public const string ENVIRONMENT = "sandbox";
        public const string ENVIRONMENT = "Live";
        //public const string ECURLLOGIN = "https://developer.paypal.com";
        public const string ECURLLOGIN = "https://www.paypal.com/cgi-bin/webscr";
        
        //for one time run
        public static string _strKashFlowPassword="";
        public static string _strKashFlowUserName="";
        public static string _strPayPalPassword="";
        public static string _strPayPalUserName="";
        public static string _strPayPalSignature="";

        public static void LoadPayPalConstants()
        {
            
            KashFlowPayPal.Classes.ProgramOptions objOpt = new ProgramOptions();
            objOpt.LoadXMLSettings();
            API_USERNAME = objOpt.PayPalUserName;
            API_PASSWORD = PayPalConstants.DecryptPString("payp.bin");
            API_SIGNATURE = objOpt.PayPalSignature;
            KASH_API_PASSWORD = PayPalConstants.DecryptPString("kashp.bin");//objOpt.KashFlowUserPassword;
            KASH_API_USERNAME = objOpt.KashFlowUserName;
            //for one time application run
            if (API_USERNAME == "" && _strPayPalUserName != "")
                API_USERNAME = _strPayPalUserName;
            if (API_PASSWORD == "" && _strPayPalPassword!= "")
                API_PASSWORD = _strPayPalPassword;
            if (API_SIGNATURE== "" && _strPayPalSignature!= "")
                API_SIGNATURE = _strPayPalSignature;
            if (API_USERNAME == "" && _strPayPalUserName != "")
                API_USERNAME = _strPayPalUserName;
            if (API_USERNAME == "" && _strPayPalUserName != "")
                API_USERNAME = _strPayPalUserName;



            }
        /*
                public const string API_USERNAME = "sdk-three_api1.sdk.com";
                public const string API_PASSWORD = "QFZCWN5HZM8VBG7Q";
                public const string API_SIGNATURE = "AVGidzoSQiGWu.lGj3z15HLczXaaAcK6imHawrjefqgclVwBe8imgCHZ";
                public const string CERTIFICATE = "";
                public const string PRIVATE_KEY_PASSWORD = "";
                public const string SUBJECT = "";
                public const string ENVIRONMENT = "sandbox";
                public const string ECURLLOGIN = "https://developer.paypal.com";
        */
        public static void EncryptPString(String strPassword,string fileName)
        {
            /**************** Encrypt/Protect Database String ****************/

            // Convert the string to a byte array:
            byte[] arrDBString = System.Text.Encoding.Unicode.GetBytes(strPassword);

            // Provide additional protection via entropy with another byte array:
            byte[] arrEntropy = { 4, 5, 7, 9, 4, 5, 7, 9 }; // Save this for unprotecting later

            // Encrypt/protect the DB string:
            byte[] arrEncryptedDBString = ProtectedData.Protect(arrDBString, arrEntropy,
                DataProtectionScope.CurrentUser);

            // Write the encrypted DB string to disk:
            using (FileStream fs = new FileStream(fileName, FileMode.OpenOrCreate))
            {
                fs.Write(arrEncryptedDBString, 0, arrEncryptedDBString.Length);
            }

        }

        // This method will decrypt the saved encrypted DB string
        public static string DecryptPString(string fileName)
        {
            try
            {
                String strUnencryptedDBString = null;

                // Provide additional protection via entropy with another byte array:
                byte[] arrEntropy = { 4, 5, 7, 9, 4, 5, 7, 9 }; // Save this for protecting later

                // Setup the byte array that will hold the encrypted DB string:
                byte[] arrEncryptedDBString = new byte[0];

                // Read the encrypted DB string from disk:
                if (File.Exists(fileName))
                {
                    using (FileStream fs = new FileStream(fileName, FileMode.Open))
                    {
                        // Reset the byte array's length based on read length:
                        arrEncryptedDBString = new byte[fs.Length];
                        // Read the encrypted file into the byte array:
                        fs.Read(arrEncryptedDBString, 0, (int)fs.Length);
                    }
                }

                if (arrEncryptedDBString.Length > 0)
                {
                    // Decrypt/unprotect the DB string:
                    byte[] arrUnencryptedDBString = ProtectedData.Unprotect(arrEncryptedDBString,
                        arrEntropy, DataProtectionScope.CurrentUser);

                    // Convert the byte array to a string:
                    strUnencryptedDBString = System.Text.Encoding.Unicode.GetString(arrUnencryptedDBString);
                }

                // Return the unencrypted DB string:
                return strUnencryptedDBString;
            }
            catch { }
            return "";

        }


    }
}
