using System;
using System.Collections.Generic;
using System.Text;
using com.paypal.sdk.services;
using com.paypal.soap.api;
namespace KashFlowPayPal.Classes
{
    public class PayPalAPI
    {
        private readonly CallerServices caller;
        MassPayRequestType pp_request = new MassPayRequestType();
        MassPayRequestItemType MassItemReq = new MassPayRequestItemType();

        public PayPalAPI()
        {
            caller = new CallerServices();
            caller.APIProfile = SetProfile.DefaultProfile;
        }

        public TransactionSearchResponseType TransactionSearch(DateTime startDate, DateTime endDate, string transactionId)
        {
            // Create the request object
            TransactionSearchRequestType concreteRequest = new TransactionSearchRequestType();
            

            concreteRequest.StartDate = startDate;
            concreteRequest.EndDate = endDate;//endDate.AddHours(23).AddMinutes(59).AddSeconds(59);
            concreteRequest.EndDateSpecified = true;
            concreteRequest.TransactionClass = PaymentTransactionClassCodeType.Received;
            concreteRequest.TransactionClassSpecified = true;
            concreteRequest.TransactionID = transactionId;

            return (TransactionSearchResponseType)caller.Call("TransactionSearch", concreteRequest);
        }

        public GetTransactionDetailsResponseType GetTransactionDetails(string trxID)
        {
            caller.APIProfile = SetProfile.DefaultProfile;
            // Create the request object
            GetTransactionDetailsRequestType concreteRequest = new GetTransactionDetailsRequestType();

            concreteRequest.TransactionID = trxID;
            return (GetTransactionDetailsResponseType)caller.Call("GetTransactionDetails", concreteRequest);
        }

        
        //voids an order or an authorization.
        public DoVoidResponseType DoVoid(string authorizationId, string note)
        {
            DoVoidRequestType pp_request = new DoVoidRequestType();
            pp_request.AuthorizationID = authorizationId;
            pp_request.Note = note;
            return (DoVoidResponseType)caller.Call("DoVoid", pp_request);
        }

        public DoCaptureResponseType DoCapture(string authorizationId, string note, string value, CurrencyCodeType currencyId, string invoiceId)
        {
            DoCaptureRequestType pp_request = new DoCaptureRequestType();
            pp_request.AuthorizationID = authorizationId;
            pp_request.Note = note;
            pp_request.Amount = new BasicAmountType();
            pp_request.Amount.Value = value;
            pp_request.Amount.currencyID = currencyId;
            pp_request.InvoiceID = invoiceId;
            return (DoCaptureResponseType)caller.Call("DoCapture", pp_request);
        }

        public DoAuthorizationResponseType DoAuthorization(string orderId, string value, CurrencyCodeType currencyId)
        {
            DoAuthorizationRequestType pp_request = new DoAuthorizationRequestType();
            pp_request.TransactionID = orderId;
            pp_request.Amount = new BasicAmountType();
            pp_request.Amount.Value = value;
            pp_request.Amount.currencyID = currencyId;
            return (DoAuthorizationResponseType)caller.Call("DoAuthorization", pp_request);
        }
        public DoReauthorizationResponseType DoReAuthorization(string authorizationId, string value, CurrencyCodeType currencyId)
        {
            DoReauthorizationRequestType pp_request = new DoReauthorizationRequestType();
            pp_request.AuthorizationID = authorizationId;
            pp_request.Amount = new BasicAmountType();
            pp_request.Amount.Value = value;
            pp_request.Amount.currencyID = currencyId;
            return (DoReauthorizationResponseType)caller.Call("DoReauthorization", pp_request);
        }
     

    }
}
