using System;
using System.Collections.Generic;
using System.Text;
using KashFlowPayPal.uk.co.kashflow.secure;
namespace KashFlowPayPal.Classes
{
    class KashAPI
    {
        public static string strStatus;
        public static string strStatusDetail;
        private static Customer[] cus;
        private static Product[] products;
        private static BankTXType[] banktx;
        public static bool booVatreg;
        KashAPI()
        { 
            
        }
        public static Customer[] GetCustomers()
        {
            KashFlowAPI kash = new KashFlowAPI();
            cus = kash.GetCustomers(PayPalConstants.KASH_API_USERNAME, PayPalConstants.KASH_API_PASSWORD, out strStatus, out strStatusDetail);
            return cus;
        }
        public static int GetCustomerID(string cusName)
        {
            foreach (Customer c in cus)
            {
                if (c.Name == cusName)
                    return c.CustomerID;
            }
            return 0;
        }

        public static string GetCustomerName(string customerID)
        {
            foreach (Customer c in cus)
            {
                if (Convert.ToString(c.CustomerID) == customerID)
                    return c.Name;
            }
            return "";
        }

        internal static Product[] GetProducts()
        {
            KashFlowAPI kash = new KashFlowAPI();
            products = kash.GetProducts(PayPalConstants.KASH_API_USERNAME, PayPalConstants.KASH_API_PASSWORD, out strStatus, out strStatusDetail);
            return products;
        }

        public static int GetProductID(string productName)
        {
            foreach (Product p in products)
            {
                if (p.ProductName == productName)
                    return p.ProductID;
            }
            return 0;
        }

        public static string GetProductName(int productID)
        {
            foreach (Product p in products)
            {
                if (p.ProductID == productID)
                    return p.ProductName;
            }
            return "";
        }

        internal static BankTXType[] GetBankTXTypes()
        {
            KashFlowAPI kash = new KashFlowAPI();
            banktx = kash.GetBankTxTypes(PayPalConstants.KASH_API_USERNAME, PayPalConstants.KASH_API_PASSWORD, out strStatus, out strStatusDetail);
            return banktx;
        }

        public static int GetTxID(string txName)
        {
            foreach (BankTXType tx in banktx)
            {
                if (tx.TypeName == txName)
                    return tx.TypeID;
            }
            return 0;
        }

        public static string GetTxName(int txID)
        {
            foreach (BankTXType tx in banktx)
            {
                if (tx.TypeID == txID)
                    return tx.TypeName;
            }
            return "";
        }

        public static bool isUserVATRegistered()
        {
            KashFlowAPI kash = new KashFlowAPI();
            booVatreg = kash.isUserVATRegistered(PayPalConstants.KASH_API_USERNAME, PayPalConstants.KASH_API_PASSWORD, out strStatus, out strStatusDetail);
            return booVatreg;
        }

    }
    
}
