unit Unit1;


 // v1.0  13/06/13
 // some simple examples of using the KashFlow API
 // Built with Delphi 2010 Pro - No 3rd party elements used
 // Also tested in Delphi Xe4
 //  To create the unit 'service' I used the IDE WSDL import wizard
 // point it at https://securedwebapp.com/api/service.asmx?WSDL
 // I've not edited that in anyway - the 'cannot unwrap' messages in Service.pas may prove to be an issue further down the road ?
 // I used the Delphi Soap client THTTPRIO
 //      Set its WSDLLocation property to  https://securedwebapp.com/api/service.asmx?WSDL
 //      You can then select  Port  KashFlowAPISoap12  (I tried  the alternate KashFlowAPISoap but it generated errors)
 //      Select the Service KashFlowAPI
 //   you should then be good to go !    (see note about XE4 below)

 //   THIS MAY be obvious to others but had me foooled for a few minutes :  'LATE BINDING'
 //   Using TXSDecimal / TXsDate etc  : The XML elements aquire their values at the time the XML is emitted - using the bindings
 //   created as you popultae the fields (not always the same as the values you think you are populating the fields with)
 //    e.g. if those values are derived from an object such as a TXSDecimal.
 //   So don't try to use the same instance of a TXSDecimal with different values to populate the decimal fields of an object
 //   they will all end up with the same value (the last one you used) when you generate the xml.

 //  I have used 'emitter' and 'receiver' as names for the API Get.... Class and Get....Respose Class respectively
 //  helps me visualise whats going on.

 // This has been tested with Dekphi 2010 and XE4 (The service.pas generated by the WSDL wizard in XE4 does not work.
 // It fails with the message 'interface not supported' - I have not investigated this further - the D2010 service.pas
 // does work in Delphi XE4.
 // The parser used by THTTPRIO component chokes at 'complex' <g> structures - such as multiple 'anytype' entries e.g invoice lines.
 // I simply kept the exception silent and passed the XML to a more capable parser.
 // e.g. In the OnAfterExecute event pour the stream returned by the server into whatever you like.
 // The simple parser produced by    Stefan Heymann  www.destructor.de    does a great job - Thamks Stefan


 // May not be the most elegant or efficient code but hopefully useful. If you improve / add to it
 // it would be nice to share those changes.

 // Harry Rogers June 2013 harry@aspxx.co.uk





interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, service, InvokeRegistry, Rio, SOAPHTTPClient, StdCtrls, xsbuiltins,
  ExtCtrls, Grids, strutils;

type
  TfmMain = class(TForm)
    HTTPRIO1: THTTPRIO;
    btnGetCust: TButton;
    edAcCode: TEdit;
    memResult: TMemo;
    btnMakeCust: TButton;
    btnCreateInv: TButton;
    edUserName: TEdit;
    edPassword: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    edCode: TEdit;
    Label9: TLabel;
    Label10: TLabel;
    edName: TEdit;
    Label11: TLabel;
    edTel: TEdit;
    Label12: TLabel;
    edContact: TEdit;
    Label13: TLabel;
    edEmail: TEdit;
    btnClear: TButton;
    Label14: TLabel;
    edInvCustId: TEdit;
    Label15: TLabel;
    edOrderNo: TEdit;
    sgInvLines: TStringGrid;
    Label16: TLabel;
    edInvoiceEmail: TEdit;
    Label17: TLabel;
    btnGetInv: TButton;
    Bevel5: TBevel;
    edInvNo: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    procedure btnGetCustClick(Sender: TObject);
    procedure btnMakeCustClick(Sender: TObject);
    procedure btnCreateInvClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure edUserNameExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnGetInvClick(Sender: TObject);
    procedure HTTPRIO1AfterExecute(const MethodName: string;
      SOAPResponse: TStream);
    procedure HTTPRIO1Converter1UnhandledNode(const Name: string;
      NodeXML: string);
   function Occurrences(const Substring, Text: string): integer;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure enableinput( bCanproceed : boolean);
  end;

var
  fmMain: TfmMain;


implementation

{$R *.dfm}

 // not used now
 // Andreas Rejbrand on StackOverflow provided this means of counting substrings
 // http://stackoverflow.com/questions/5265317/delphi-count-number-of-times-a-string-occurs-in-another-string
function TfmMain.Occurrences(const Substring, Text: string): integer;
var
  offset: integer;
begin
  result := 0;
  offset := PosEx(Substring, Text, 1);
  while offset <> 0 do
  begin
    inc(result);
    offset := PosEx(Substring, Text, offset + length(Substring));
  end;
end;

// don't let the user enter any data without first supplying a username and password
// If a components Tag property is 1 it will be enablebde/disabled.
procedure TfmMain.enableinput( bCanproceed : boolean);
  var
  i: integer;
  Temp: TComponent;
begin
  for i := 0 to fmMain.ComponentCount-1 do
    begin
      Temp := fmMain.Components[i];
      if Tcomponent(Temp).tag = 1 then
      Tcontrol(Temp).Enabled := bCanProceed;
    end;
end;

// some titles for the invoice lines
 procedure TfmMain.FormCreate(Sender: TObject);
begin
 sgInvlines.cells[0,0] := 'Quant';
 sgInvlines.cells[1,0] := 'Description';
 sgInvlines.cells[2,0] := 'Vat %';
 sgInvlines.cells[3,0] := 'Price';
end;


// Lets capture each respons to a file
procedure TfmMain.HTTPRIO1AfterExecute(const MethodName: string;  SOAPResponse: TStream);
 var
  SL : TStringList;
begin
  // the returned xml is a stream - grab it into a stringlist
    SL := TStringList.Create;
    try
      SOAPResponse.Position := 0;
      SL.LoadFromSTream(SOAPREsponse);
      // once in a stringlist we can do what we like with it
      // lets just save to a file
      SL.SaveToFile('thexml.xml');
      // if we manipulate the response text at all we need to write it back
      // if we are going to let the HTTPRIO do its stuff
      // in this case we have only read it so we don't need the following
   //   SOAPResponse.Position := 0;
   //   SOAPResponse.size := length(SL.Text);
   //   SL.SaveToStream(SOAPResponse);
    finally
      SL.free;
    end;
end;


procedure TfmMain.HTTPRIO1Converter1UnhandledNode(const Name: string;
  NodeXML: string);
begin
 // should never get here as exceptions are swallowed earlier
 showmessage('Unhandled');
end;


// retrieve a customer - using the customercode generated when an account is added -(not the account code)
procedure TfmMain.btnGetCustClick(Sender: TObject);
 var
  emitter : GetCustomer;
  receiver : GetCustomerResponse;

begin
try
 //create the objects we need
 emitter := Getcustomer.create;
 receiver := GetCustomerResponse.create;

 //Set the properties / Parameters
 // the 'parameter list'  is often 3 'properties' in delphi terms
 // the KashFlow Username,  Password, and some value or object
   emitter.UserName := edUserName.text;
   emitter.Password := edPassword.text;
   emitter.customercode := edAcCode.text  ;
  with Httprio1 as KashFlowAPISoap do
 begin
   receiver := GetCustomer(emitter);
  end;
   //stick some fields into a memo so we can see what was returned
   memResult.lines.add(inttostr(receiver.GetCustomerResult.CustomerID) + ' : ' +
    receiver.GetCustomerResult.Code + ' : ' +
    receiver.GetCustomerResult.Name_ + ' : ' +
    receiver.GetCustomerResult.ContactFirstName + ' : ' +
    receiver.GetCustomerResult.email );

 finally
  receiver := nil;
  emitter  := nil;
  receiver.free;
  emitter.free;
 end;
end;

//get an Invoice using its invoice no
procedure TfmMain.btnGetInvClick(Sender: TObject);
 var
  emitter : GetInvoice;
  receiver : GetInvoiceResponse;

begin
 try
   emitter := GetInvoice.create;
   receiver := GetInvoiceResponse.create;

  with emitter do
   begin
    UserName := edUserName.text;
    Password := edPassword.text;
    InvoiceNumber := strtoint(edInvno.text);
   end;

 //HTTPRIO chokes on this - "Element 'anytype' does not contain a single text node"
 // wouldn't expect it to point to a single text node really would you from looking at the WSDL?
 // The XML is returned before the exception though so we can process it ourselves
 // not elegant but functional !
  try
  with Httprio1 as KashFlowAPISoap do
    begin
     receiver := GetInvoice(emitter);
    end;
  except
    //silent;
  end;

 finally
   receiver := nil;
   emitter := nil;
   receiver.free;
   emitter.free;
 end;
end;

// Adding a new customer
// Empty numeric fields generate errors
// when emitted (they look like null strings to the server)
procedure TfmMain.btnMakeCustClick(Sender: TObject);
 var
  emitter : InsertCustomer;
  receiver : InsertCustomerResponse;
  aCust : customer;
  aDisc : Txsdecimal;
  aDate : TxsDateTime;
  iNewId : integer;
begin
  try
  aDisc := TXSDecimal.Create;
  aDisc.DecimalString := '0.0';
  aDate := TxsDateTime.create;
  aDate.AsDateTime := now;
  aCust := customer.create;
with aCust do
 begin
  Code      := edCode.text;
  Name_     := edName.text;
  Contact   := edContact.text;
  Telephone := edTel.text;
  Mobile    := '';
  Fax       := '';
  Email     := edemail.text;
  //etc  etc
  Address1  := 'Add line 1';
  Address2  := 'Add line 2';
  Address3  := 'Add line 3';
  Address4  := 'Add line 4';
  Postcode  := 'BR27 9HQ';
  Website   := '';
  EC        :=  1;
  OutsideEC :=  0;
  Notes     :=  'Some Notes';
  Source    := 1;
  Discount  := aDisc;
  ShowDiscount := True;
  PaymentTerms  := 1;
  ExtraText1    := '';
  ExtraText2    := '';
  ExtraText3    := '';
  ExtraText4    := '';
  ExtraText5    := '';
  ExtraText6    := '';
  ExtraText7    := '';
  ExtraText8    := '';
  ExtraText9    := '';
  ExtraText10    := '';
  ExtraText11    := '';
  ExtraText12    := '';
  ExtraText13    := '';
  ExtraText14    := '';
  ExtraText15    := '';
  ExtraText16    := '';
  ExtraText17    := '';
  ExtraText18    := '';
  ExtraText19    := '';
  ExtraText20    := '';
  CheckBox1      := 0;
  CheckBox2      := 0;
  CheckBox3      := 0;
  CheckBox4      := 0;
  CheckBox5      := 0;
  CheckBox6      := 0;
  CheckBox7      := 0;
  CheckBox8      := 0;
  CheckBox9      := 0;
  CheckBox10      := 0;
  CheckBox11      := 0;
  CheckBox12      := 0;
  CheckBox13      := 0;
  CheckBox14      := 0;
  CheckBox15      := 0;
  CheckBox16      := 0;
  CheckBox17      := 0;
  CheckBox18      := 0;
  CheckBox19      := 0;
  CheckBox20      := 0;
  Created         := aDate;
  Updated         := aDate;
  CurrencyID      := 1;
  ContactTitle    := 'Mr';
  ContactFirstName := 'Jon';
  ContactLastName  := 'Smith';
  CustHasDeliveryAddress   := 1;
  DeliveryAddress1 := 'Del Line1';
  DeliveryAddress2 := 'Del Line2';
  DeliveryAddress3 := 'Del Line3';
  DeliveryAddress4 := 'Del Line4';
  DeliveryPostcode := 'AB21 3JA';
 end;

   emitter  := InsertCustomer.create;
   receiver := InsertCustomerResponse.create;

   with emitter do
   begin
    UserName := edUserName.text;
    Password := edPassword.text;
    custr := aCust;
   end;

   with Httprio1 as KashFlowAPISoap do
    begin
     receiver := InsertCustomer(emitter);
    end;
     iNewId := receiver.InsertCustomerResult;
   //lets see the unique Id of the created customer
    if iNewID > 1 then
     showmessage('Customer with account code "' + edCode.text + '" added. With a Unique ID of' + inttostr(receiver.InsertCustomerResult))
    else
      showmessage('There was an error - Customer with ' + edCode.text + ' Was not added.');

 finally
   aCust := nil;
   aCust.Free;
   receiver := nil;
   emitter := nil;
   receiver.free;
   emitter.free;
   aDisc := nil;
   aDate := nil;
   aDisc.free;
   aDate.free;
 end;

end;



// check if we want to allow user input
procedure TfmMain.edUserNameExit(Sender: TObject);
begin
 enableinput((edUserName.text <> '') and (edPassword.text <> '') );
end;

// clear the new customer GUI elements
procedure TfmMain.btnClearClick(Sender: TObject);
begin
 edCode.text := '';
 edName.text := '';
 edTel.text := '';
 edContact.text := '';
 edEmail.text := '';
end;



// making an invoice
// first the header and then add line(s)
// using the invoice number
// this uses InsertInvoice and then InsertInvoiceLineWithNumber
procedure TfmMain.btnCreateInvClick(Sender: TObject);
 var
  emitter : InsertInvoice;
  receiver : InsertInvoiceResponse;
  TheEmail : EmailInvoice;
  TheEmailResponse : EmailInvoiceResponse;
  aVal : TxsDecimal;
  aDate : TXSDateTime;
  aInv : Invoice;
  aLine : invoiceline;
  insInvLine : InsertInvoiceLineWithInvoiceNumber;
  insInvLineR : InsertInvoiceLineWithInvoiceNumberResponse;
    // Transaction ID version
   // insInvLine : InsertInvoiceLine;
   // insInvLineR : InsertInvoiceLineResponse;
  iLineNo : integer;
  rValue : real;
  iInvRes : integer;
  // invline values
  txQuant, txPrice, txVatRate, txVatVal : TxsDecimal;

begin
 try
  //create , Populate and post Invoice object
  // this is the header
   aDate := TxsDateTime.create;
   aVal := TxsDecimal.create;

   aDate.asdatetime := now;
   aVal.DecimalString := '0.0';

   aInv := invoice.create;
   with aInv do
   begin
     InvoiceNumber := 0;    // KF will auto increment the value
     InvoiceDate := aDate;
     DueDate := aDate;     //payable on presentation
     SuppressTotal := 0;
     ProjectID := 0;
     CurrencyCode := 'GBP';
     ExchangeRate := Aval;  //KF will set to 1 for the home currency
     Paid := 0;
     //we are using the Customer Unique ID you can get this if you created the customer as above.
     // or from getting a customer  - its the 1st numeric in the result memo lines;
     CustomerID :=  strtoint(edInvCustId.text);
     CustomerReference := edOrderNo.text;
     NetAmount := Aval;        // KF will calc these as lines are added.
     VATAmount := Aval;
     AmountPaid := Aval;
     permalink := '';  // KF will populate with a URL of the PDF represenation of the Document (No login required)
   end;
   emitter  := InsertInvoice.create;
   receiver := InsertInvoiceResponse.create;

   emitter.UserName := edUserName.Text;
   emitter.Password := edPassword.Text;
   emitter.Inv :=   aInv;

   with Httprio1 as KashFlowAPISoap do
    begin
     receiver := InsertInvoice(emitter);
    end;

  // if successfule proceed to added inv lines
   iInvRes := receiver.InsertINvoiceResult;
   if iInvRes >0 then
    begin
      showmessage('Invoice Header created with a Nmber  of ' + inttostr(iInvres) );
//    Now add invlines - use the Invoice Number version
      insInvLine := InsertInvoiceLineWithInvoiceNumber.create;
      insInvLineR := InsertInvoiceLineWithInvoiceNumberResponse.create;
      //this method uses the transaction ID rather than the Invoice No
      //insInvLine := InsertInvoiceLine.create;
      //insInvLineR := InsertInvoiceLineResponse.create;
      aline := Invoiceline.create;
      txQuant   := TxsDecimal.create;
      txPrice   := TxsDecimal.create;
      txVatRate := TxsDecimal.create;
      txVatVal  := TxsDecimal.create;
      iLineNo := 1;
      //keep adding lines from rows while the stringgrid quantity cell has values
     while sgInvLines.cells[0,ilineNo] <> '' do
     begin
       //quantity
      txQuant.DecimalString := sgInvLines.cells[0,ilineNo];
      aline.Quantity :=  txQuant;
      //descript,nominal,project,product
      aline.Description := sgInvLines.cells[1,ilineNo];
      aline.ChargeType := 4001;  // the nominal code
      aline.ProjID := 0;
      aline.ProductID := 0;
       //vat rate
      txVatRate.DecimalString := sgInvLines.cells[2,ilineNo];
      aline.VatRate := txVatRate;
       //line item nett value
      txPrice.DecimalString := sgInvLines.cells[3,ilineNo];
      aline.Rate := txPrice;
  //   calc the correct vat
      rValue := strtofloat(txQuant.DecimalString) * strtofloat(txVatRate.DecimalString) /100 * strtofloat(txPrice.DecimalString);
      txVatVal.DecimalString := FloatToStr(rValue);
      aline.VatAmount := txVatVal;
      aline.sort := 1;  // sort is the invoice line no for visual representation. KF will autoincrement this for each line if you don't specify an order

     // Nowe add the line to an existing Header - using the Invoice Number as reference;
      insInvLine.UserName := edUserName.text;
      insInvLine.Password := edPassword.text;
       // used with InsertInvoicelineWithNumber
      insInvLine.InvoiceNumber := iInvRes;  // Add Lines to the existing Invoice Number
      //if using the ID verfsion
     // insInvLine.InvoiceID := iInvRes;
      insInvLine.InvLine := aline;
        with Httprio1 as KashFlowAPISoap do
         begin
          insInvLineR := InsertInvoiceLineWithInvoiceNumber(insInvLine);
         end;
     // lets see the unique ID of the inserted line
      showmessage('Invoice Line Created with Unique ID of ' + inttostr(insInvLineR.InsertInvoiceLineWithInvoiceNumberResult));
      inc(iLineNo);
     end; //lines
     //if an email address supplied then send it
      if  edInvoiceEmail.text <> '' then
       begin
        TheEmail         := EmailInvoice.create;
        TheEmailResponse := EmailInvoiceResponse.create;
         With TheEmail do
          begin
           InvoiceNumber := iInvRes;
           FromEmail := 'accounts@thedemoco.co.uk';
           RecipientEmail := edInvoiceEmail.text;
           SubjectLine := 'Your Latest Invoice';
           Body := 'Hi from the demo Co. The Attached PDF contains your latest Invoice from us. Thanks for your Business';
           UserName := edUserName.text;
           Password := edPassword.text;
             with Httprio1 as KashFlowAPISoap do
              begin
               TheEmailResponse := EmailInvoice(TheEmail);
              end;
          end;
       end;
    end  //Header creation
   else
   begin
     showmessage('The Invoice creation encountered an error');
   end;
 finally
   TheEmail := nil;
   TheEmailResponse := nil;
   TheEmail.free;
   TheEmailResponse.free;
   aline := nil;
   aline.free;
   insInvLine := nil;
   insInvLine.free;
   insInvLineR := nil;
   insInvLineR.free;
   txQuant.free;
   txPrice.free;
   txVatRate.free;
   txVatVal.free;
   receiver := nil;
   emitter := nil;
   receiver.free;
   emitter.free;
   Aval := nil;
   adate := nil;
   aInv := nil;
   aInv.free;
 end;
end;

end.
